# 剑指 Offer 刷题计划

剑指 Offer 系列题目非常适合作为算法入门题目集，尤其适合有互联网求职需求的同学们，能够让我们全面练习，快速搭建起算法与数据结构的知识框架。

- 算法： 动态规划、回溯算法、查找算法、搜索算法、贪心算法、分治算法、位运算、双指针、排序、模拟、数学、……
- 数据结构： 数组、栈、队列、字符串、链表、树、图、堆、哈希表、……

笔者整理了本刷题计划，核心理念为从易到难、从基础类题目到综合类题目，供希望按照知识点类型顺序刷题的小伙伴们参考。

> 行百里者半九十。坚持一个月刷完，一起加油！

|    日程    | 题目                                          |
| :--------: | :-------------------------------------------- |
| **Day 1**  | **栈与队列（简单）**                          |
|            | 剑指 Offer 09. 用两个栈实现队列               |
|            | 剑指 Offer 30.  包含 min 函数的栈             |
| **Day 2**  | **链表（简单）**                              |
|            | 剑指 Offer 06. 从尾到头打印链表               |
|            | 剑指 Offer 24. 反转链表                       |
|            | 剑指 Offer 35. 复杂链表的复制                 |
| **Day 3**  | **字符串（简单）**                            |
|            | 剑指 Offer 05. 替换空格                       |
|            | 剑指 Offer 58 - II. 左旋转字符串              |
| **Day 4**  | **查找算法（简单）**                          |
|            | 剑指 Offer 03. 数组中重复的数字               |
|            | 剑指 Offer 53 - I. 在排序数组中查找数字 I     |
|            | 剑指 Offer 53 - II. 0～n-1 中缺失的数字       |
| **Day 5**  | **查找算法（中等）**                          |
|            | 剑指 Offer 04. 二维数组中的查找               |
|            | 剑指 Offer 11. 旋转数组的最小数字             |
|            | 剑指 Offer 50. 第一个只出现一次的字符         |
| **Day 6**  | **搜索与回溯算法（简单）**                    |
|            | 剑指 Offer 32 - I. 从上到下打印二叉树         |
|            | 剑指 Offer 32 - II. 从上到下打印二叉树 II     |
|            | 剑指 Offer 32 - III. 从上到下打印二叉树 III   |
| **Day 7**  | **搜索与回溯算法（简单）**                    |
|            | 剑指 Offer 26. 树的子结构                     |
|            | 剑指 Offer 27. 二叉树的镜像                   |
|            | 剑指 Offer 28. 对称的二叉树                   |
| **Day 8**  | **动态规划（简单）**                          |
|            | 剑指 Offer 10- I. 斐波那契数列                |
|            | 剑指 Offer 10- II. 青蛙跳台阶问题             |
|            | 剑指 Offer 63. 股票的最大利润                 |
| **Day 9**  | **动态规划（中等）**                          |
|            | 剑指 Offer 42. 连续子数组的最大和             |
|            | 剑指 Offer 47. 礼物的最大价值                 |
| **Day 10** | **动态规划（中等）**                          |
|            | 剑指 Offer 46. 把数字翻译成字符串             |
|            | 剑指 Offer 48. 最长不含重复字符的子字符串     |
| **Day 11** | **双指针（简单）**                            |
|            | 剑指 Offer 18. 删除链表的节点                 |
|            | 剑指 Offer 22. 链表中倒数第 k 个节点          |
| **Day 12** | **双指针（简单）**                            |
|            | 剑指 Offer 25. 合并两个排序的链表             |
|            | 剑指 Offer 52. 两个链表的第一个公共节点       |
| **Day 13** | **双指针（简单）**                            |
|            | 剑指 Offer 21. 调整数组顺序使奇数位于偶数前面 |
|            | 剑指 Offer 57. 和为 s 的两个数字              |
|            | 剑指 Offer 58 - I. 翻转单词顺序               |
| **Day 14** | **搜索与回溯算法（中等）**                    |
|            | 剑指 Offer 12. 矩阵中的路径                   |
|            | 剑指 Offer 13. 机器人的运动范围               |
| **Day 15** | **搜索与回溯算法（中等）**                    |
|            | 剑指 Offer 34. 二叉树中和为某一值的路径       |
|            | 剑指 Offer 36. 二叉搜索树与双向链表           |
|            | 剑指 Offer 54. 二叉搜索树的第 k 大节点        |
| **Day 16** | **排序（简单）**                              |
|            | 剑指 Offer 45. 把数组排成最小的数             |
|            | 剑指 Offer 61. 扑克牌中的顺子                 |
| **Day 17** | **排序（中等）**                              |
|            | 剑指 Offer 40. 最小的 k 个数                  |
|            | 剑指 Offer 41. 数据流中的中位数               |
| **Day 18** | **搜索与回溯算法（中等）**                    |
|            | 剑指 Offer 55 - I. 二叉树的深度               |
|            | 剑指 Offer 55 - II. 平衡二叉树                |
| **Day 19** | **搜索与回溯算法（中等）**                    |
|            | 剑指 Offer 64. 求 1 + 2 + … + n               |
|            | 剑指 Offer 68 - I. 二叉搜索树的最近公共祖先   |
|            | 剑指 Offer 68 - II. 二叉树的最近公共祖先      |
| **Day 20** | **分治算法（中等）**                          |
|            | 剑指 Offer 07. 重建二叉树                     |
|            | 剑指 Offer 16. 数值的整数次方                 |
|            | 剑指 Offer 33. 二叉搜索树的后序遍历序列       |
| **Day 21** | **位运算（简单）**                            |
|            | 剑指 Offer 15. 二进制中 1 的个数              |
|            | 剑指 Offer 65. 不用加减乘除做加法             |
| **Day 22** | **位运算（中等）**                            |
|            | 剑指 Offer 56 - I. 数组中数字出现的次数       |
|            | 剑指 Offer  56 - II. 数组中数字出现的次数 II  |
| **Day 23** | **数学（简单）**                              |
|            | 剑指 Offer 39. 数组中出现次数超过一半的数字   |
|            | 剑指 Offer 66. 构建乘积数组                   |
| **Day 24** | **数学（中等）**                              |
|            | 剑指 Offer 14- I. 剪绳子                      |
|            | 剑指 Offer 57 - II. 和为 s 的连续正数序列     |
|            | 剑指 Offer 62. 圆圈中最后剩下的数字           |
| **Day 25** | **模拟（中等）**                              |
|            | 剑指 Offer 29. 顺时针打印矩阵                 |
|            | 剑指 Offer 31. 栈的压入、弹出序列             |
| **Day 26** | **字符串（中等）**                            |
|            | 剑指 Offer 20. 表示数值的字符串               |
|            | 剑指 Offer 67. 把字符串转换成整数             |
| **Day 27** | **栈与队列（困难）**                          |
|            | 剑指 Offer 59 - I. 滑动窗口的最大值           |
|            | 剑指 Offer 59 - II. 队列的最大值              |
| **Day 28** | **搜索与回溯算法（困难）**                    |
|            | 剑指 Offer 37. 序列化二叉树                   |
|            | 剑指 Offer 38. 字符串的排列                   |
| **Day 29** | **动态规划（困难）**                          |
|            | 剑指 Offer 19. 正则表达式匹配                 |
|            | 剑指 Offer 49. 丑数                           |
|            | 剑指 Offer 60. n 个骰子的点数                 |
| **Day 30** | **分治算法（困难）**                          |
|            | 剑指 Offer 17. 打印从 1 到最大的 n 位数       |
|            | 剑指 Offer 51. 数组中的逆序对                 |
| **Day 31** | **数学（困难）**                              |
|            | 剑指 Offer 14- II. 剪绳子 II                  |
|            | 剑指 Offer 43. 1～n 整数中 1 出现的次数       |
|            | 剑指 Offer 44. 数字序列中某一位的数字         |
